
--Rain parameters
kPPS = 10;               -- Number of particles generated per second
kGravity =100;            -- Gravity in pixels/second/second

-- kBlendNormal
-- kBlendOpaque
-- kBlendAdditive
-- kBlendAdditiveAlpha
-- kBlendSubtractive
-- kBlendLit

function Init()
  SetTexture("flower1");
  SetBlendMode(kBlendNormal);
  SetNumParticles(100);
end

floor = math.floor

ParticlesPerSecond = NewParticleGenerator();
StopSpouting = NewTimeout(5500);
TestDone = NewTimeout(9000);

function Update(ms)
  if (TestDone(ms)) then
    SetDone();
    return ;
  end
  local newParticles = ParticlesPerSecond( kPPS,ms );

  if (not StopSpouting(ms)) then
   InitPosition( "vRange", Vec3(-350, -400, 0), Vec3(350,-350,0) );
   InitVelocity( "vRange", Vec3(-10, 250, 0), Vec3(10,150, 0) );
   InitScale( "fRange", 1, 1 );
   InitAge("iRange", 0, 0);
   CreateParticles(newParticles);
  end

   Do("move");
   DoAge("iAge");
   DoColor("cFade",
      Color(1, 1,1, 1), 5000,
      Color(1, 1, 1, 0));
   Do("expire", 6000)

DoUp( "vRotate", -.2, .5 );


end

